﻿$(function () {

    var $answerBlock = $(".questionBlock");
    var $errors = $("div.errorMessage", $answerBlock);
    var startRatingUpdate = function () {
        var element = $("div.starRating", this);
        var type = GetQuestionType(element);
        if (type == "StarRating") {
            UpdateStartRating(element);
        }
    };
    $answerBlock.find("div.questionBackground").each(function (index, block) {

        var $context = $("[data-questiontype='hybridgrid']", block);
        var disableAutoCollapse = $("[data-disable-auto-collapse='True']", block);

        var $errorBlock = $("div.errorMessage", block);
        var firstDisplayedIndex = $(".accordionRow:not(.clientSideSkipped):not(.serverSideSkippedhideif)", block).first().index();

        $(".accordionRow", block).each(function (index, row) {
            var $rowHeader = $("p", row);
            var $inputs = $("input", row);
            var $checkboxInputs = $("input[type=checkbox]", row);
            var maxAnswer = $("fieldset", row).attr("data-maxanswers");

            var event = function () {
                SetAccordionRowHeaderAnswer(this);
            };

            if ($rowHeader.length > 0) {   //simple grid or row of hybird grid
                if ($context.length == 0) {

                    // add event to field type
                    $inputs.each(function (index, rowEventInput) {

                        if (this.type == "radio") {
                            $(rowEventInput).on('click', event);
                        }
                        else if (this.type == "checkbox") {
                            $(rowEventInput).on('change', event);
                        }
                    });

                    //on back show answer on header of accordion
                    var $checkedinputs = $("input:checked", row);
                    if ($checkedinputs.length > 0) {
                        SetAccordionRowHeaderAnswer($checkedinputs[0]);
                    }
                }



                if ($checkboxInputs.length == 0 || ($checkboxInputs.length > 0 && maxAnswer >= 1)) {
                    //open the first ligne if they don't have error
                    if (index == firstDisplayedIndex && $errorBlock.not(".errorMessageSoftPrompt").length == 0) {
                        $rowHeader.addClass("active");
                        var $panel = $("div.accordionRowContent", this).first();
                        $panel.delay(200).slideDown(200, startRatingUpdate);
                    }
                }
                //event on click in header accordion
                $rowHeader.on("click", function () {
                    //if accordion row isn't open then open it and close all other else don't do  anything
                    var isActive = this.className.indexOf("active") > -1;
                    var position = this.parentNode.getAttribute("data-row-position");
                    var $container = $(this).closest(".questionContent");
                    var $rowToChange = $("div[data-row-position=" + position + "]", $container);
                    var $panel = $("div.accordionRowContent", $rowToChange).first();

                    $("p", $rowToChange).toggleClass("active");

                    if (isActive) {
                        $panel.delay(200).slideUp(200);

                    } else {
                        $panel.delay(200).slideDown(200, startRatingUpdate);

                        if ((window.innerHeight) < $panel[0].offsetTop - window.scrollY) {
                            $('html,body').animate({
                                scrollTop: $("div.accordionRowContent", $rowToChange)[0].offsetTop - 50
                            }, 'slow');
                        }
                    }
                });

            }
            else {
                var $panel = $("div.accordionRowContent", this);
                $panel.css("display", "block");
            }
            if (disableAutoCollapse.length > 0 || $context.length > 0 || ($checkboxInputs.length > 0 && (maxAnswer == null || maxAnswer == 0))) {
                $rowHeader.addClass("active");
                var $panel = $("div.accordionRowContent", this).first();
                $panel.css("display", "block");
            }
        })
    });

    if ($errors.length > 0) {
        $(function () {
            var $errorMessage = $errors.first();
            var $container = $errorMessage.closest("div.accordionRow");
            var $typeQuestion = $container.closest("div[data-questiontype]");
            if ($container.length > 0) {
                if ($typeQuestion != "hybridgrid") {
                    var positionClidren = $container.attr("data-column-position");
                    var $panel = $("div.accordionRowContent", $container).first();
                    $("p", $container).addClass("active");
                    $panel.delay(200).slideDown(200, startRatingUpdate);
                }

                if ((window.innerHeight) < $container[0].offsetTop - window.scrollY + 50) {
                    $('html,body').animate({
                        scrollTop: $container[0].offsetTop - 50
                    }, 'slow');
                }
            }
        })
    }

});


//Simple Grid
function SetAccordionRowHeaderAnswer(element) {
    var type = GetQuestionType(element);
    var answerValue = GetColumnAnswer(element, type);
    var positionParent = $(element).closest("div[data-row-position]").attr("data-row-position");
    var disableAutoCollapse = $(element).closest("div[data-disable-auto-collapse]").attr("data-disable-auto-collapse");
    var questionID = $(element).closest("div.questionBackground").attr("id");
    var actuelGridRowHeader = $("div#" + questionID + " div[data-row-position=" + positionParent + "] p.gridRowHeader");
    var $fieldset = $(element).closest("fieldset");
    var maxAnswer = $fieldset.attr("data-maxanswers");
    var $chekedInput = $("input:checked", $fieldset);
    var $contextInput = $("input", $fieldset);

    if (type == "RadioButton" || (type == "StarRating")) {

        actuelGridRowHeader.find("div.answerLabels").remove();
        actuelGridRowHeader.find("br.answerLabels").remove();
        actuelGridRowHeader.append("<br class=\"answerLabels\"/><div class=\"answerLabels\" id =\"answerLabels_" + questionID + "_" + positionParent + "\">" + answerValue + "</div>");

    }
    else if (type == "Checkbox") {
        var valueElement = $(element).val();
        var answerLabels = $("#answerLabels_" + positionParent).text();
        var questionContent = $(element).closest("div.questionContent");

        if (answerLabels == null)
            answerLabels = "";

        if (maxAnswer > 1 || maxAnswer == null) {
            $(element).closest("div[data-row-position=" + positionParent + "]").find("input").each(function () {
                //Getlabel on changed input
                var inputLabel = $(this).closest("div").find(".choiceText").text().trim();
                if (inputLabel == "") {
                    inputLabel = $(this).closest("div.choice").find(".choiceText").text().trim();
                }
                answerLabels = GetChoiceGridAnswer($(this)[0], answerLabels, inputLabel);
            });
        } else {
            var inputLabel = $(element).closest("div").find(".choiceText").text().trim();
            if (inputLabel == "") {
                inputLabel = $(this).closest("div.choice").find(".choiceText").text().trim();
            }
            answerLabels = GetChoiceGridAnswer($(element)[0], answerLabels, inputLabel);
        }

        if (actuelGridRowHeader.find("div#answerLabels_" + questionID + "_" + positionParent).length == 0) {
            actuelGridRowHeader.append("<br class=\"answerLabels\"/><div class=\"answerLabels\" id =\"answerLabels_" + questionID + "_" + positionParent + "\">" + answerLabels + "</div>");
        }
        else {
            $("#answerLabels_" + questionID + "_" + positionParent).text(answerLabels);
        }
    }
    if (!disableAutoCollapse || disableAutoCollapse.toLocaleLowerCase() === "false") {
        if (type == "RadioButton" || (type == "Checkbox" && maxAnswer >= 1 && (maxAnswer == $chekedInput.length || $contextInput.length == $chekedInput.length)) || (type == "StarRating")) {
            var indexElement = $(element).closest("div.questionContent").find("div[data-row-position]:visible").index($(element).closest("div.accordionRow"));

            var divArray = $(element).closest("div.questionContent").find("div[data-row-position]:visible");

            var $contextDiv = $(element).closest("div.questionContent");
            var $accordionRow = $contextDiv.find("div[data-row-position=" + (parseInt($(divArray[indexElement]).attr("data-row-position"))) + "]");
            if ($(".openEnd", $accordionRow).length === 0) {
                ExpandNextRow(indexElement, divArray, $contextDiv);
                $("p", $accordionRow).first().trigger("click");
            } else {
                $(".openEnd", $accordionRow)
                    .data("custom-callback", function () { ManageRowExpansion($accordionRow, indexElement, divArray, $contextDiv); });
            }
        }
    }
}

function ManageRowExpansion($accordionRow, indexElement, divArray, $contextDiv) {
    const selectedOpenEnd = $(".openEnd:visible:not(:disabled)", $accordionRow);
    if ($(".openEnd", $accordionRow).length === 0 || selectedOpenEnd.length === 0) {
        ExpandNextRow(indexElement, divArray, $contextDiv);
        $("p", $accordionRow).first().trigger("click");
    } else {
        ExpandNextRow(indexElement, divArray, $contextDiv);
    }
}

function ExpandNextRow(indexElement, divArray, $contextDiv) {
    for (var i = indexElement; i < divArray.length; i++) {
        if ($(divArray[i]).find("input:checked").length == 0) {
            var $contextRow = $contextDiv.find("div[data-row-position=" +
                (parseInt($(divArray[i]).attr("data-row-position"))) +
                "] > p").first();

            if (!$contextRow.hasClass("active")) {
                $contextRow.trigger("click");
                break;
            }
        }
    }
}

function GetChoiceGridAnswer(element, answerLabels, inputLabel) {
    if (element.checked && answerLabels.indexOf(inputLabel) == -1) {
        answerLabels += (answerLabels != "" ? ", " : "") + inputLabel
    }
    else if (!(element.checked) && answerLabels.indexOf(inputLabel) > -1) {
        if (answerLabels.indexOf(", " + inputLabel) > -1) {
            answerLabels = answerLabels.replace(", " + inputLabel, '').trim();
        }
        else {
            answerLabels = answerLabels.replace(inputLabel, '').trim();

            if (answerLabels.indexOf(",") == 0) {
                answerLabels = answerLabels.substring(1, answerLabels.length).trim()
            }
        }
    }
    return answerLabels;
}


function UpdateStartRating(element) {
    $(element).starRating("refreshLayout");
    $("div", element).each(function (index, startItem) {
        $(startItem).on("click", function () {
            SetAccordionRowHeaderAnswer(this);
        });
    })
}


function GetQuestionType(element) {
    var type = ""
    switch (element.type) {
        case "checkbox":
            type = "Checkbox";
            break;
        case "radio":
            type = "RadioButton";
            break;
        case "select-one":
            type = "DropDown";
            break;
        case "number":
            if (element.parentElement.className == "ui-slider") {
                type = "Slider";
            }
            break;
        case "text":
            type = "TextBox";
            break;
        default:
            if ($(element).closest("div.starRating").length > 0) {
                type = "StarRating";
            }
            break;
    }

    return type
}

function GetColumnAnswer(element, type) {
    var answer = "";
    switch (type) {
        case "RadioButton":
            answer = $("label[for='" + element.id + "']").text();
            break;
        case "DropDown":
            answer = $(element).find('option:selected').text().trim();
            break;
        case "Slider":
            answer = $(element).val().trim();
            break;
        case "TextBox":
            answer = $(element).val().trim();
            break;
        case "StarRating":
            var values = $(element).closest("div.starRating:not(.initializable)").starRating("getRating");
            answer = (values == null || values.length == 0 ? "" : values);
            break;
    }

    return answer
}